<?php

// contains the default values of all available properties
$sp_default_slider_settings = array('width'  =>  500, 
									'height' => 300,
									'skin' => 'pixel',
									'scrollbar_skin' => 'scrollbar-1',
									'align_type' => 'leftTop', 
									'slide_start' => 0, 
									'slides_preloaded' => 0, 
									'shuffle' => false,
									'skip_broken' => true,
									'link_target' => '_blank',
									'slideshow' => true, 
									'slideshow_delay' => 5000, 
									'slideshow_direction' => 'next', 
									'slideshow_controls' => true,
									'fade_slideshow_controls' => true, 
									'slideshow_controls_show_duration' => 500,
									'slideshow_controls_hide_duration' => 500,
									'pause_slideshow_on_hover' => false, 
									'lightbox' => false, 
									'lightbox_default_width' => 500,
									'lightbox_default_height' => 300,
									'lightbox_theme' => 'pp_default',
									'lightbox_opacity' => 0.8,
									'lightbox_navigation' => true,
									'fade_previous_slide' => false,
									'fade_previous_slide_duration' => 300,
									'shadow' => true,
									'timer_animation' => true, 
									'timer_fade_duration' => 500, 
									'fade_timer' => false,
									'timer_radius' => 18, 
									'timer_stroke_color1' => '#000000', 
									'timer_stroke_color2' => '#FFFFFF', 
									'timer_stroke_opacity1' => 0.5, 
									'timer_stroke_opacity2' => 0.7,
									'timer_stroke_width1' => 8, 
									'timer_stroke_width2' => 4, 
									'override_transition' => false, 
									'effect_type' => 'random',
									'html_during_transition' => true,
									'simple_slide_direction' => 'autoHorizontal', 
									'simple_slide_duration' => 700, 
									'simple_slide_easing' => 'swing', 
									'slice_delay' => 50, 
									'slice_duration' => 1000,
									'slice_easing' => 'swing', 
									'horizontal_slices' => 5, 
									'vertical_slices' => 3, 
									'slice_pattern' => 'random', 
									'slice_point' => 'centerCenter',
									'slide_start_position' => 'left', 
									'slide_start_ratio' => 1, 
									'slice_fade' => true, 
									'slide_mask' => false, 
									'navigation_arrows' => true,
									'fade_navigation_arrows' => true,
									'navigation_arrows_show_duration' => 500,
									'navigation_arrows_hide_duration' => 500, 
									'navigation_buttons' => true, 
									'navigation_buttons_center' => true,
									'navigation_buttons_container_center' => true,									
									'fade_navigation_buttons' => false,
									'navigation_buttons_show_duration' => 500,
									'navigation_buttons_hide_duration' => 500,
									'navigation_buttons_numbers' => false,
									'thumbnail_slide_amount' => 10, 
									'thumbnail_slide_duration' => 300, 
									'thumbnail_slide_easing' => 'swing',
									'thumbnail_width' => 80,
									'thumbnail_height' => 50,
									'thumbnails_type' => 'tooltip',
									'fade_navigation_thumbnails' => false, 
									'navigation_thumbnails_hide_duration' => 500, 
									'navigation_thumbnails_show_duration' => 500,
									'navigation_thumbnails_center' => true,
									'thumbnail_sync' => false, 
									'visible_thumbnails' => 5,
									'thumbnail_orientation' => 'horizontal',
									'thumbnail_tooltip' => false,
									'thumbnail_arrows' => true, 
									'fade_thumbnail_arrows' => false,
									'thumbnail_scroll_duration' => 1000, 
									'thumbnail_scroll_easing' => 'swing', 
									'thumbnail_arrows_hide_duration' => 500, 
									'thumbnail_arrows_show_duration' => 500,								
									'thumbnail_buttons' => false, 
									'fade_thumbnail_buttons' => false,
									'thumbnail_buttons_hide_duration' => 500,
									'thumbnail_buttons_show_duration' => 500, 
									'thumbnail_scrollbar' => false, 
									'fade_thumbnail_scrollbar' => false, 
									'thumbnail_scrollbar_hide_duration' => 500,
									'thumbnail_scrollbar_show_duration' => 500, 
									'thumbnail_scrollbar_ease' => 10, 
									'scrollbar_arrow_scroll_amount' => 100,								
									'thumbnail_mouse_scroll' => false, 
									'thumbnail_mouse_scroll_speed' => 10, 
									'thumbnail_mouse_scroll_ease' => 90, 
									'thumbnail_mouse_wheel' => false,
									'thumbnail_mouse_wheel_speed' => 20, 
									'thumbnail_mouse_wheel_reverse' => false,
									'thumbnail_caption_position' => 'bottom', 
									'hide_thumbnail_caption' => true, 
									'thumbnail_caption_effect' => 'slide', 
									'thumbnail_caption_show_duration' => 500, 
									'thumbnail_caption_hide_duration' => 500, 
									'thumbnail_caption_easing' => 'swing', 
									'tooltip_show_duration' => 300, 
									'tooltip_hide_duration' => 300, 
									'hide_caption' => false,
									'caption_position' => 'bottom',										
									'caption_background_opacity' => 0.5, 
									'caption_background_color' => '#000000', 
									'caption_show_effect' => 'slide', 
									'caption_show_effect_duration' => 500,
									'caption_show_effect_easing' => 'swing', 
									'caption_show_slide_direction' => 'auto', 
									'caption_hide_effect' => 'fade', 
									'caption_hide_effect_duration' => 300,
									'caption_hide_effect_easing' => 'swing', 
									'caption_hide_slide_direction' => 'auto', 
									'caption_size' => 70, 
									'caption_left' => 50, 
									'caption_top' => 50,
									'caption_width' => 300, 
									'caption_height' => 100);



$sp_default_slide_settings = array('align_type' => 'leftTop',
									'link_target' => '_blank',
									'slideshow_delay' => 5000, 
									'effect_type' => 'random', 									
									'html_during_transition' => true,
									'fade_previous_slide' => false,
									'fade_previous_slide_duration' => 300,
									'simple_slide_direction' => 'autoHorizontal', 
									'simple_slide_duration' => 700, 
									'simple_slide_easing' => 'swing', 
									'slice_delay' => 50, 
									'slice_duration' => 1000,
									'slice_easing' => 'swing', 
									'horizontal_slices' => 5, 
									'vertical_slices' => 3, 
									'slice_pattern' => 'random', 
									'slice_point' => 'centerCenter',
									'slide_start_position' => 'left', 
									'slide_start_ratio' => 1, 
									'slice_fade' => true, 
									'slide_mask' => false,
									'lightbox_default_width' => 500,
									'lightbox_default_height' => 300,
									'lightbox_theme' => 'pp_default',
									'lightbox_opacity' => 0.8,
									'caption_position' => 'bottom',										
									'caption_background_opacity' => 0.5, 
									'caption_background_color' => '#000000', 
									'caption_show_effect' => 'slide', 
									'caption_show_effect_duration' => 500,
									'caption_show_effect_easing' => 'swing', 
									'caption_show_slide_direction' => 'auto', 
									'caption_hide_effect' => 'fade', 
									'caption_hide_effect_duration' => 300,
									'caption_hide_effect_easing' => 'swing', 
									'caption_hide_slide_direction' => 'auto', 
									'caption_size' => 70, 
									'caption_left' => 50, 
									'caption_top' => 50,
									'caption_width' => 300, 
									'caption_height' => 100);


$sp_slider_settings_lists = array(  'align_type' => array('leftTop', 'centerTop', 'rightTop', 'leftCenter', 'centerCenter', 'rightCenter', 'leftBottom', 'centerBottom', 'rightBottom'),
								  
									'link_target' => array('_blank', '_self', '_parent', '_top'),
									
									'effect_type' => array('random', 'scale', 'fade', 'slide', 'width', 'height', 'simpleSlide'),
									
									'thumbnails_type' => array('tooltip', 'navigation', 'none'),
									
									'slice_pattern' => array('randomPattern', 'topToBottom', 'bottomToTop', 'leftToRight', 'rightToLeft', 'topLeftToBottomRight', 'topRightToBottomLeft', 'bottomLeftToTopRight',
														   'bottomRightToTopLeft', 'horizontalMarginToCenter', 'horizontalCenterToMargin', 'verticalMarginToCenter', 'verticalCenterToMargin', 'skipOneTopToBottom',
														   'skipOneBottomToTop', 'skipOneLeftToRight', 'skipOneRightToLeft', 'skipOneHorizontal', 'skipOneVertical', 'spiralMarginToCenterCW', 'spiralMarginToCenterCCW',
														   'spiralCenterToMarginCW', 'spiralCenterToMarginCCW', 'random'),
									
									'easing' => array('swing', 'easeInQuad', 'easeOutQuad', 'easeInOutQuad', 'easeInCubic', 'easeOutCubic', 'easeInOutCubic', 'easeInQuart', 'easeOutQuart', 'easeInOutQuart',
													'easeInQuint', 'easeOutQuint', 'easeInOutQuint', 'easeInSine', 'easeOutSine', 'easeInOutSine', 'easeInExpo', 'easeOutExpo', 'easeInOutExpo', 
													'easeInCirc', 'easeOutCirc', 'easeInOutCirc', 'easeInElastic', 'easeOutElastic', 'easeInOutElastic', 'easeInBack', 'easeOutBack', 'easeInOutBack', 
													'easeInBounce', 'easeOutBounce', 'easeInOutBounce'),
									
									'slice_point' => array('leftTop', 'centerTop', 'rightTop', 'leftCenter', 'centerCenter', 'rightCenter', 'leftBottom', 'centerBottom', 'rightBottom'),
									
									'slide_start_position' => array('left', 'right', 'top', 'bottom', 'leftTop', 'rightTop', 'leftBottom', 'rightBottom', 'horizontalAlternativ', 'verticalAlternativ', 'random'),
									
									'simple_slide_direction' => array('random', 'autoHorizontal', 'autoVertical', 'rightToLeft', 'leftToRight', 'topToBottom', 'bottomToTop'),
									
									'slideshow_direction' => array('next', 'previous'),
									
									'thumbnail_orientation' => array('horizontal', 'vertical'),
									
									'thumbnail_caption_position' => array('bottom', 'top'),
									
									'thumbnail_caption_effect' => array('slide', 'fade'),
									
									'caption_position' => array('bottom', 'top', 'left', 'right', 'custom'),
									
									'caption_effect' => array('slide', 'fade'),
									
									'caption_slide_direction' => array('auto', 'topToBottom', 'bottomToTop', 'leftToRight', 'rightToLeft'),
									
									'lightbox_theme' => array('pp_default', 'light_rounded', 'dark_rounded', 'light_square', 'dark_square', 'facebook'));



// associates the properties with a shortname
$sp_settings_shortname = array('leftTop' => 'TL', 'centerTop' => 'TC', 'rightTop' => 'TR', 'leftCenter' => 'CL', 'centerCenter' => 'CC', 
							   'rightCenter' => 'CR', 'leftBottom' => 'BL', 'centerBottom' => 'BC', 'rightBottom' => 'BR',
							  
							   'randomPattern' => 'RND', 'topToBottom' => 'T->B', 'bottomToTop' => 'B->T', 'leftToRight' => 'L->R', 'rightToLeft' => 'R->L', 'topLeftToBottomRight' => 'TL->BR', 
							   'topRightToBottomLeft' => 'TR->BL', 'bottomLeftToTopRight' => 'BL->TR', 'bottomRightToTopLeft' => 'BR->TL', 'horizontalMarginToCenter' => 'H M->C', 
							   'horizontalCenterToMargin' => 'H C->M', 'verticalMarginToCenter' => 'V M->C', 'verticalCenterToMargin' => 'V C->M', 'skipOneTopToBottom' => 'S1 T->B', 
							   'skipOneBottomToTop' => 'S1 B->T', 'skipOneLeftToRight' => 'S1 L->R', 'skipOneRightToLeft' => 'S1 R->L', 'skipOneHorizontal' => 'S1 H', 'skipOneVertical' => 'S1 V', 
							   'spiralMarginToCenterCW' => 'S M->C 1', 'spiralMarginToCenterCCW' => 'S M->C 2', 'spiralCenterToMarginCW' => 'S C->M 1', 'spiralCenterToMarginCCW' => 'S C->M 2', 'random' => 'random',
							   
							   'swing' => 'swing', 'easeInQuad' => 'Quad I', 'easeOutQuad' => 'Quad O', 'easeInOutQuad' => 'Quad IO', 'easeInCubic' => 'Cubic I', 'easeOutCubic' => 'Cubic O', 'easeInOutCubic' => 'Cubic IO', 
							   'easeInQuart' => 'Quart I', 'easeOutQuart' => 'Quart O', 'easeInOutQuart' => 'Quart IO', 'easeInQuint' => 'Quint I', 'easeOutQuint' => 'Quint O', 'easeInOutQuint' => 'Quint IO', 
								'easeInSine' => 'Sine I', 'easeOutSine' => 'Sine O', 'easeInOutSine' => 'Sine IO', 'easeInExpo' => 'Expo I', 'easeOutExpo' => 'Expo O', 'easeInOutExpo' => 'Expo IO', 
								'easeInCirc' => 'Circ I', 'easeOutCirc' => 'Circ O', 'easeInOutCirc' => 'Circ IO', 'easeInElastic' => 'Elastic I', 'easeOutElastic' => 'Elastic O', 'easeInOutElastic' => 'Elastic IO', 
								'easeInBack' => 'Back I', 'easeOutBack' => 'Back O', 'easeInOutBack' => 'Back IO', 'easeInBounce' => 'Bounce I', 'easeOutBounce' => 'Bounce O', 'easeInOutBounce' => 'Bounce IO',
								
								'auto' => 'auto', 'autoHorizontal' => 'auto H', 'autoVertical' => 'auto V',
								
								'left' => 'L', 'right' => 'R', 'top' => 'T', 'bottom' => 'B', 'horizontalAlternativ' => 'H Alt', 'verticalAlternativ' => 'V Alt',
								
								'horizontal' => 'H', 'vertical' => 'V');



// associates a setting with the javascript name of the property
$sp_js_properties = array('width' => 'width', 
						'height' => 'height',
						'skin' => 'skin', 
						'scrollbar_skin' => 'scrollbarSkin', 
						'align_type' => 'alignType', 
						'slide_start' => 'slideStart', 
						'slides_preloaded' => 'slidesPreloaded', 
						'shuffle' => 'shuffle',
						'skip_broken' => 'skipBroken',
						'link_target' => 'linkTarget',
						'fade_previous_slide' => 'fadePreviousSlide',
						'fade_previous_slide_duration' => 'fadePreviousSlideDuration',
						'slideshow' => 'slideshow', 
						'slideshow_delay' => 'slideshowDelay', 
						'slideshow_direction' => 'slideshowDirection', 
						'slideshow_controls' => 'slideshowControls',
						'fade_slideshow_controls' => 'fadeSlideshowControls',
						'slideshow_controls_show_duration' => 'slideshowControlsShowDuration',
						'slideshow_controls_hide_duration' => 'slideshowControlsHideDuration', 
						'pause_slideshow_on_hover' => 'pauseSlideshowOnHover', 
						'lightbox' => 'lightbox', 
						'lightbox_default_width' => 'lightboxDefaultWidth',
						'lightbox_default_height' => 'lightboxDefaultHeight',
						'lightbox_theme' => 'lightboxTheme',
						'lightbox_opacity' => 'lightboxOpacity',
						'lightbox_navigation' => 'lightboxNavigation',
						'shadow' => 'shadow',
						'timer_animation' => 'timerAnimation', 
						'timer_fade_duration' => 'timerFadeDuration', 
						'fade_timer' => 'fadeTimer', 
						'timer_radius' => 'timerRadius', 
						'timer_stroke_color1' => 'timerStrokeColor1', 
						'timer_stroke_color2' => 'timerStrokeColor2', 
						'timer_stroke_opacity1' => 'timerStrokeOpacity1', 
						'timer_stroke_opacity2' => 'timerStrokeOpacity2', 
						'timer_stroke_width1' => 'timerStrokeWidth1', 
						'timer_stroke_width2' => 'timerStrokeWidth2', 
						'override_transition' => 'overrideTransition', 
						'effect_type' => 'effectType',
						'html_during_transition' => 'htmlDuringTransition',
						'simple_slide_direction' => 'simpleSlideDirection', 
						'simple_slide_duration' => 'simpleSlideDuration', 
						'simple_slide_easing' => 'simpleSlideEasing', 
						'slice_delay' => 'sliceDelay', 
						'slice_duration' => 'sliceDuration', 
						'slice_easing' => 'sliceEasing', 
						'horizontal_slices' => 'horizontalSlices', 
						'vertical_slices' => 'verticalSlices', 
						'slice_pattern' => 'slicePattern', 
						'slice_point' => 'slicePoint', 
						'slide_start_position' => 'slideStartPosition', 
						'slide_start_ratio' => 'slideStartRatio', 
						'slice_fade' => 'sliceFade', 
						'slide_mask' => 'slideMask', 
						'navigation_arrows' => 'navigationArrows', 
						'fade_navigation_arrows' => 'fadeNavigationArrows', 
						'navigation_arrows_show_duration' => 'navigationArrowsShowDuration',
						'navigation_arrows_hide_duration' => 'navigationArrowsHideDuration', 
						'navigation_buttons' => 'navigationButtons', 
						'navigation_buttons_center' => 'navigationButtonsCenter',									
						'navigation_buttons_container_center' => 'navigationButtonsContainerCenter',									
						'fade_navigation_buttons' => 'fadeNavigationButtons',
						'navigation_buttons_show_duration' => 'navigationButtonsShowDuration',
						'navigation_buttons_hide_duration' => 'navigationButtonsHideDuration',
						'navigation_buttons_numbers' => 'navigationButtonsNumbers',
						'thumbnail_slide_amount' => 'thumbnailSlideAmount', 
						'thumbnail_slide_duration' => 'thumbnailSlideDuration', 
						'thumbnail_slide_easing' => 'thumbnailSlideEasing',
						'fade_navigation_thumbnails' => 'fadeNavigationThumbnails', 
						'navigation_thumbnails_hide_duration' => 'navigationThumbnailsHideDuration',
						'navigation_thumbnails_show_duration' => 'navigationThumbnailsShowDuration', 
						'navigation_thumbnails_center' => 'navigationThumbnailsCenter', 
						'thumbnail_sync' => 'thumbnailSync', 
						'visible_thumbnails' => 'visibleThumbnails',
						'thumbnails_type' => 'thumbnailsType',
						'thumbnail_width' => 'thumbnailWidth',
						'thumbnail_height' => 'thumbnailHeight',
						'thumbnail_orientation' => 'thumbnailOrientation', 
						'thumbnail_arrows' => 'thumbnailArrows', 
						'fade_thumbnail_arrows' => 'fadeThumbnailArrows', 
						'thumbnail_scroll_duration' => 'thumbnailScrollDuration', 
						'thumbnail_scroll_easing' => 'thumbnailScrollEasing', 
						'thumbnail_arrows_hide_duration' => 'thumbnailArrowsHideDuration', 
						'thumbnail_arrows_show_duration' => 'thumbnailArrowsShowDuration', 
						'thumbnail_buttons' => 'thumbnailButtons', 
						'fade_thumbnail_buttons' => 'fadeThumbnailButtons',  
						'thumbnail_buttons_hide_duration' => 'thumbnailButtonsHideDuration', 
						'thumbnail_buttons_show_duration' => 'thumbnailButtonsShowDuration', 
						'thumbnail_scrollbar' => 'thumbnailScrollbar', 
						'fade_thumbnail_scrollbar' => 'fadeThumbnailScrollbar', 
						'thumbnail_scrollbar_hide_duration' => 'thumbnailScrollbarHideDuration',
						'thumbnail_scrollbar_show_duration' => 'thumbnailScrollbarShowDuration', 
						'thumbnail_scrollbar_ease' => 'thumbnailScrollbarEase',
						'scrollbar_arrow_scroll_amount' => 'scrollbarArrowScrollAmount',								
						'thumbnail_mouse_scroll' => 'thumbnailMouseScroll', 
						'thumbnail_mouse_scroll_speed' => 'thumbnailMouseScrollSpeed', 
						'thumbnail_mouse_scroll_ease' => 'thumbnailMouseScrollEase', 
						'thumbnail_mouse_wheel' => 'thumbnailMouseWheel',
						'thumbnail_mouse_wheel_speed' => 'thumbnailMouseWheelSpeed', 
						'thumbnail_mouse_wheel_reverse' => 'thumbnailMouseWheelReverse',
						'thumbnail_caption_position' => 'thumbnailCaptionPosition', 
						'hide_thumbnail_caption' => 'hideThumbnailCaption', 
						'thumbnail_caption_effect' => 'thumbnailCaptionEffect', 
						'thumbnail_caption_show_duration' => 'thumbnailCaptionShowDuration', 
						'thumbnail_caption_hide_duration' => 'thumbnailCaptionHideDuration', 
						'thumbnail_caption_easing' => 'thumbnailCaptionEasing', 
						'thumbnail_tooltip' => 'thumbnailTooltip',
						'tooltip_show_duration' => 'tooltipShowDuration', 
						'tooltip_hide_duration' => 'tooltipHideDuration', 
						'caption_position' => 'captionPosition',
						'hide_caption' => 'hideCaption', 
						'caption_background_opacity' => 'captionBackgroundOpacity', 
						'caption_background_color' => 'captionBackgroundColor', 
						'caption_show_effect' => 'captionShowEffect', 
						'caption_show_effect_duration' => 'captionShowEffectDuration',
						'caption_show_effect_easing' => 'captionShowEffectEasing', 
						'caption_show_slide_direction' => 'captionShowSlideDirection', 
						'caption_hide_effect' => 'captionHideEffect', 
						'caption_hide_effect_duration' => 'captionHideEffectDuration',
						'caption_hide_effect_easing' => 'captionHideEffectEasing', 
						'caption_hide_slide_direction' => 'captionHideSlideDirection',
						'caption_size' => 'captionSize', 
						'caption_left' => 'captionLeft', 
						'caption_top' => 'captionTop',
						'caption_width' => 'captionWidth', 
						'caption_height' => 'captionHeight');


// contains some description for each of the available settings
$sp_properties_help = array('skin' => __('The Skin of the slider.', 'slider_pro') .'<br/><b>'. 
									  __('Setting Name:', 'slider_pro') .'</b><i> skin </i>', 
							
							'scrollbar_skin'  => __('The Skin of the scrollbar.', 'slider_pro') .'<br/><b>'. 
									  			 __('Setting Name:', 'slider_pro') .'</b><i> scrollbar_skin </i>',
									  
							'include_skin' => __('In most cases you can leave this unchecked. You only need to check this if you add the slider in the header, sidebar or anywhere else outside the post/page. 
												  If checked, the selected skin will be included sitewide.', 'slider_pro'), 
							
							'width' => __('The width of the slide.', 'slider_pro') .'<br/><b>'. 
									   __('Setting Name:', 'slider_pro') .'</b><i> width </i>', 
							
							'height' => __('The height of the slide.', 'slider_pro') .'<br/><b>'. 
										__('Setting Name:', 'slider_pro') .'</b><i> height </i>', 
							
							'align_type' => __('The alignment of the slide\'s image.', 'slider_pro') .'<br/><b>'. 
											__('Setting Name:', 'slider_pro') .'</b><i> align_type </i>', 
							
							'slide_start' => __('The index of the slide which will be visible when the slider starts.', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> slide_start </i>', 
							
							'slides_preloaded' => __('Indicates how many slides will be preloaded before the first slide loads.', 'slider_pro') .'<br/><b>'. 
												  __('Setting Name:', 'slider_pro') .'</b><i> slides_preloaded </i>', 
							
							'shuffle' => __('Indicates whether the slides will be shuffled.', 'slider_pro') .'<br/><b>'. 
										 __('Setting Name:', 'slider_pro') .'</b><i> shuffle </i>', 
							
							'skip_broken' => __('Indicates whether the slides for which invalid image paths were specified, will be skipped.', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> skip_broken </i>', 
							
							'link_target' => __('The target type for links, when a link was specified for the slide.', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> link_target </i>', 
							
							'fade_previous_slide' => __('Indicates whether the previous slide will fade out during transition.', 'slider_pro') .'<br/><b>'. 
											 		 __('Setting Name:', 'slider_pro') .'</b><i> fade_previous_slide </i>', 
							
							'fade_previous_slide_duration' => __('Sets the fade out duration for the previous slide, when the feature is used.', 'slider_pro') .'<br/><b>'. 
											 		 		  __('Setting Name:', 'slider_pro') .'</b><i> fade_previous_slide_duration </i>', 
							
							'slideshow' => __('Sets the slideshow mode.', 'slider_pro') .'<br/><b>'. 
										   __('Setting Name:', 'slider_pro') .'</b><i> slideshow </i>', 
							
							'slideshow_delay' => __('Sets the delay, in milliseconds, for the slideshow mode.', 'slider_pro') .'<br/><b>'. 
												 __('Setting Name:', 'slider_pro') .'</b><i> slideshow_delay </i>', 
							
							'slideshow_direction' => __('Sets the direction of the slideshow. If \'next\' was specified the slideshow will advance to the next slide, 							
														if \'previous\' the slideshow will open the previous slide.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> slideshow_direction </i>', 
							
							'slideshow_controls' => __('Indicates whether the slideshow button will be displayed.', 'slider_pro') .'<br/><b>'. 
													__('Setting Name:', 'slider_pro') .'</b><i> slideshow_controls </i>', 
							
							'fade_slideshow_controls' => __('Indicates whether the slideshow button will fade in/out on  mouse hover.', 'slider_pro') .'<br/><b>'.
							 							 __('Setting Name:', 'slider_pro') .'</b><i> fade_slideshow_controls </i>', 
							
							'slideshow_controls_show_duration' => __('Sets the duration for the fade in animations of the slideshow button.', 'slider_pro') .'<br/><b>'. 
													 			  __('Setting Name:', 'slider_pro') .'</b><i> slideshow_controls_show_duration </i>', 
							
							'slideshow_controls_hide_duration' => __('Sets the duration for the fade out animations of the slideshow button.', 'slider_pro') .'<br/><b>'. 
													 			  __('Setting Name:', 'slider_pro') .'</b><i> slideshow_controls_hide_duration </i>', 
							
							'pause_slideshow_on_hover' => __('Indicates whether the slideshow will be paused when the mouse is over the slide.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> pause_slideshow_on_hover </i>', 
							
							'lightbox' => __('Indicates whether the lightbox will be enabled.', 'slider_pro') .'<br/><b>'. 
										  __('Setting Name:', 'slider_pro') .'</b><i> lightbox </i>', 
											  
							'lightbox_default_width' => __('Sets the default width for the lightbox.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> lightbox_default_width </i>', 
											  
							'lightbox_default_height' => __('Sets the default height for the lightbox.', 'slider_pro') .'<br/><b>'. 
														 __('Setting Name:', 'slider_pro') .'</b><i> lightbox_default_height </i>', 
											  
							'lightbox_theme' => __('Sets the theme of the lightbox.', 'slider_pro') .'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> lightbox_theme </i>', 
											  
							'lightbox_opacity' => __('Sets the opacity of the lightbox\'s overlay.', 'slider_pro') .'<br/><b>'. 
												  __('Setting Name:', 'slider_pro') .'</b><i> lightbox_opacity </i>', 
												  
							'lightbox_navigation' => __('Indicates whether the navigation will be enabled in the lightbox.', 'slider_pro') .'<br/><b>'. 
												  	 __('Setting Name:', 'slider_pro') .'</b><i> lightbox_navigation </i>', 
							
							'shadow' => __('Indicates whether the slider shadow will be displayed.', 'slider_pro') .'<br/><b>'. 
										__('Setting Name:', 'slider_pro') .'</b><i> shadow </i>', 
													 
							'timer_animation' => __('Indicates whether the timer animation will be displayed.', 'slider_pro') .'<br/><b>'. 
												 __('Setting Name:', 'slider_pro') .'</b><i> timer_animation </i>', 
							
							'timer_fade_duration' => __('Sets the duration for the fade in/out animation of the timer.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> timer_fade_duration </i>', 
							
							'fade_timer' => __('Indicates whether the timer will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
											__('Setting Name:', 'slider_pro') .'</b><i> fade_timer </i>', 
							
							'timer_radius' => __('Sets the radius of the timer.', 'slider_pro') .'<br/><b>'. 
											  __('Setting Name:', 'slider_pro') .'</b><i> timer_radius </i>', 
									
							'timer_stroke_color1' => __('Sets the color of the timer\'s back stroke.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_color1 </i>', 
							
							'timer_stroke_color2' => __('Sets the color of the timer\'s front stroke.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_color2 </i>', 
							
							'timer_stroke_opacity1' => __('Sets the opacity of the timer\'s back stroke.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_opacity1 </i>', 
							
							'timer_stroke_opacity2' => __('Sets the opacity of the timer\'s front stroke.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_opacity2 </i>', 
							
							'timer_stroke_width1' => __('Sets the width of the timer\'s back stroke.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_width1 </i>', 
							
							'timer_stroke_width2' => __('Sets the width of the timer\'s front stroke.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> timer_stroke_width2 </i>', 
							
							'override_transition' => __('Indicates whether it\'s permitted to start a new transition while another one is in progress.', 'slider_pro') .'<br/><b>'.
													 __('Setting Name:', 'slider_pro') .'</b><i> override_transition </i>', 
							
							'effect_type' => __('Sets the transition effect type.', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> effect_type </i>', 
							
							'html_during_transition' => __('Indicates whether specified HTML content will be displayed while the transition is in progress. A transition which displayes HTML will be slower.', 'slider_pro')
													 		.'<br/><b>'. __('Setting Name:', 'slider_pro') .'</b><i> html_during_transition </i>', 							
							
							'simple_slide_direction' => __('Sets the direction of the Simple Slide effect', 'slider_pro') . '<br/><br/><b>'. 
														__('Short names:', 'slider_pro') . '</b><br/>
														   T - top ; B - bottom ; L - left ; R - right <br/>
														   -> - to (shows the direction) <br/>
														   auto H - auto Horizontal <br/>
														   auto V - auto Vertical <br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> simple_slide_direction </i>', 
							
							'simple_slide_duration' => __('Sets the duration of the Simple Slide effect.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> simple_slide_duration </i>', 
							
							'simple_slide_easing' => __('Sets the easing of the Simple Slide effect', 'slider_pro') . '<br/><br/><b>'. 
													 __('Short names:', 'slider_pro') . '</b><br/>
													 	I - in; O - out; IO - inOut <br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> simple_slide_easing </i>', 
							
							'slice_delay' => __('Sets the delay between each slice (square) animation.', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> slice_delay </i>', 
										
							'slice_duration' => __('Sets the duration of each slice animation.', 'slider_pro') .'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> slice_duration </i>', 
							
							'slice_easing' => __('Sets the easing of each slice animation.', 'slider_pro') .'<br/><br/><b>'. 
											  __('Short names:', 'slider_pro') . '</b><br/>
											  	 I - in; O - out; IO - inOut <br/><b>'. 
											  __('Setting Name:', 'slider_pro') .'</b><i> slice_easing </i>', 
							
							'horizontal_slices' => __('Sets the number of horizontal slices.', 'slider_pro').'<br/><b>'.
												   __('Setting Name:', 'slider_pro') .'</b><i> horizontal_slices </i>',
							
							'vertical_slices' => __('Sets the number of vertical slices.', 'slider_pro').'<br/><b>'. 
												 __('Setting Name:', 'slider_pro') .'</b><i> vertical_slices </i>', 
							
							'slice_pattern' => __('Sets the pattern in which the slices will be animated.', 'slider_pro').'<br/><br/><b>'. 
											   __('Short names:', 'slider_pro') . '</b><br/>
												   RND - random pattern <br/>
												   T - top ; B - bottom ; L - left ; R - right <br/>
												   -> - to (shows the direction) <br/>
												   M - margin ; C - center <br/>
												   H - horizontal ; V - vertical <br/>
												   S1 - skip one  <br/>
												   S - spiral <br/><b>'. 
											   __('Setting Name:', 'slider_pro') .'</b><i> slice_pattern </i>', 
							
							'slice_point' => __('Sets the point from which the slice will begin to grow when the \'scale\', \'width\' or \'height\' effects are used.', 'slider_pro').'<br/><br/><b>'. 
											 __('Short names:', 'slider_pro') . '</b><br/>
												CC - centerCenter <br/>
												TL - topLeft <br/>
												TC - topCenter <br/>
												TR - topLeft <br/>
												CL - centerLeft <br/>
												CR - centerRight <br/>
												BL - bottomLeft <br/>
												BC - bottomCenter  <br/>
												BR - bottomRight <br/><b>'.
											 __('Setting Name:', 'slider_pro') .'</b><i> slice_point </i>', 
							
							'slide_start_position' => __('Sets the starting position of the slice when the \'slide\' effect is used.', 'slider_pro').'<br/><br/><b>'. 
													  __('Short names:', 'slider_pro') . '</b><br/>
														 L - left; T - top; R- right; L - left <br/>
														 TL - topLeft; TR - topLeft; <br/> 
														 BL - bottomLeft; BR - bottomRight <br/>
														 H Alt - Horizontal Alternatively; <br/>
														 V Alt - Vertical Alternatively <br/><b>'. 
													  __('Setting Name:', 'slider_pro') .'</b><i> slide_start_position </i>', 
														 							
							'slide_start_ratio' => __('Sets the actual distance between the starting and ending point for the \'slide\' animation. 							
													  The actual distance will be determined by multiplying the slice\'s width/height to the \'slideStartRatio\' property.', 'slider_pro') .'<br/><b>'. 
												   __('Setting Name:', 'slider_pro') .'</b><i> slide_start_ratio </i>', 
							
							'slice_fade' => __('Indicates whether the slice will start as transparent and fade in when \'scale\', \'width\' or \'height\' or \'slide\' effects are used.', 'slider_pro') .'<br/><b>'. 
											__('Setting Name:', 'slider_pro') .'</b><i> slice_fade </i>', 
							
							'slide_mask' => __('Indicates whether the slices will be visible outside the slide area. This effect is relevant when the \'slide\' effect is used.', 'slider_pro') .'<br/><b>'.
											__('Setting Name:', 'slider_pro') .'</b><i> slide_mask </i>', 
							
							'navigation_arrows' => __('Indicates whether the Left and Right arrows will be displayed.', 'slider_pro') .'<br/><b>'. 
												   __('Setting Name:', 'slider_pro') .'</b><i> navigation_arrows </i>', 
							
							'fade_navigation_arrows' => __('Indicates whether the navigation arrows will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> fade_navigation_arrows </i>', 
							
							'navigation_arrows_show_duration' => __('Sets the duration for the fade in animations of the slide navigation arrows.', 'slider_pro') .'<br/><b>'. 
													 			 __('Setting Name:', 'slider_pro') .'</b><i> navigation_arrows_show_duration </i>', 
							
							'navigation_arrows_hide_duration' => __('Sets the duration for the fade out animations of the slide navigation arrows.', 'slider_pro') .'<br/><b>'. 
													 			 __('Setting Name:', 'slider_pro') .'</b><i> navigation_arrows_hide_duration </i>', 
							
							'navigation_buttons' => __('Indicates whether the navigation buttons (bullets) will be displayed.', 'slider_pro') .'<br/><b>'. 
													__('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons </i>', 
							
							'navigation_buttons_center' => __('Indicates whether the navigation buttons will be centered horizontally within the main buttons container. 							
															  If false, you can set a custom position for the buttons from within the CSS file.', 'slider_pro') .'<br/><b>'. 
														   __('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons_center </i>', 
							
							'navigation_buttons_container_center' => __('Indicates whether the navigation buttons container will be centered horizontally. 							
																	  	 If false, you can set a custom position for the container from within the CSS file.', 'slider_pro') .'<br/><b>'. 
																   	 __('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons_container_center </i>', 
							
							'fade_navigation_buttons' => __('Indicates whether the navigation buttons will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
														 __('Setting Name:', 'slider_pro') .'</b><i> fade_navigation_buttons </i>', 
							
							'navigation_buttons_show_duration' => __('Sets the duration for the fade in animations of the slide navigation buttons.', 'slider_pro') .'<br/><b>'. 
													 			  __('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons_show_duration </i>', 
							
							'navigation_buttons_hide_duration' => __('Sets the duration for the fade out animations of the slide navigation buttons.', 'slider_pro') .'<br/><b>'. 
													 			  __('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons_hide_duration </i>', 
							
							'navigation_buttons_numbers' => __('Indicates whether numbers will be displayed over the navigation buttons.', 'slider_pro') .'<br/><b>'. 
														 	__('Setting Name:', 'slider_pro') .'</b><i> navigation_buttons_numbers </i>', 
						
							'thumbnail_slide_amount' => __('Sets the sliding amount of the thumbnail, when Thumbnails Type is set to \'tooltip\'.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_slide_amount </i>', 
							
							'thumbnail_slide_duration' => __('Sets the sliding  duration of the thumbnail, when Thumbnails Type is set to \'tooltip\'.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_slide_duration </i>', 
							
							'thumbnail_slide_easing' => __('Sets the sliding easing of the thumbnail, when Thumbnails Type is set to \'tooltip\'', 'slider_pro') .'<br/><br/><b>'. 
														__('Short names:', 'slider_pro') . '</b><br/>
														    I - in; O - out; IO - inOut <br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_slide_easing </i>', 
							
							'thumbnails_type' => __('Indicates the way in which the thumbnails will be displayed. If \'tooltip\' is used the thumbnails will fade in on top of the navigation buttons when you roll over							
													 them. If \'navigation\' is used the thumbnails will appear inside the thumbnail scroller.', 'slider_pro') .'<br/><b>'.
												 __('Setting Name:', 'slider_pro') .'</b><i> thumbnails_type </i>', 
												 
							'thumbnail_width' => __('Sets the width of the thumbnail', 'slider_pro') .'<br/><b>'.
												 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_width </i>', 
												  
							'thumbnail_height' => __('Sets the height of the thumbnail', 'slider_pro') .'<br/><b>'.
												  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_height </i>', 
							
							'fade_navigation_thumbnails' => __('Indicates whether the navigation thumbnails will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
															__('Setting Name:', 'slider_pro') .'</b><i> fade_navigation_thumbnails </i>', 
							
							'navigation_thumbnails_hide_duration' => __('Sets the duration for the fade out animation of the navigation thumbnails.', 'slider_pro') .'<br/><b>'. 
																	 __('Setting Name:', 'slider_pro') .'</b><i> navigation_thumbnails_hide_duration </i>', 
							
							'navigation_thumbnails_show_duration' => __('Sets the duration for the fade in animation of the navigation thumbnails.', 'slider_pro') .'<br/><b>'. 
																	 __('Setting Name:', 'slider_pro') .'</b><i> navigation_thumbnails_show_duration </i>', 
							
							'navigation_thumbnails_center' => __('Indicates whether the navigation thumbnails will be centered relativelly to the slide.', 'slider_pro') .'<br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> navigation_thumbnails_center </i>',
							
							'thumbnail_sync' => __('Indicates whether the thumbnail page will always be synchronized with the current slide.', 'slider_pro') .'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_sync </i>', 
							
							'visible_thumbnails' => __('Sets the number of thumbnails per page.', 'slider_pro') .'<br/><b>'. 
													__('Setting Name:', 'slider_pro') .'</b><i> visible_thumbnails </i>', 
							
							'thumbnail_orientation' => __('Indicates whether the thumbnails will be arranged horizontally or vertically.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_orientation </i>', 
							
							'thumbnail_tooltip' => __('Indicates whether the tooltip will be displayed for those thumbnails for which the tooltip content was specified.', 'slider_pro') .'<br/><b>'. 
												   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_tooltip </i>', 
							
							'thumbnail_arrows' => __('Indicates whether the navigation thumbnails will have arrows for navigating through thumbnail pages.', 'slider_pro') .'<br/><b>'. 
												  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_arrows </i>', 
							
							'fade_thumbnail_arrows' => __('Indicates whether the thumbnail arrows will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> fade_thumbnail_arrows </i>',
							
							'thumbnail_scroll_duration' => __('Sets the duration of the scrolling animation when the thumbnail arrows or thumbnail buttons are used for scrolling.', 'slider_pro') .'<br/><b>'. 
														   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scroll_duration </i>', 
							
							'thumbnail_scroll_easing' => __('Sets the easing of the scrolling animation when the thumbnail arrows or thumbnail buttons are used for scrolling.', 'slider_pro') . '<br/><br/><b>'. 
														 __('Short names:', 'slider_pro') . '</b><br/>
															 I - in; O - out; IO - inOut <br/><b>'. 
														 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scroll_easing </i>', 
							
							'thumbnail_arrows_hide_duration' => __('Indicates the duration for the fade out animation of the thumbnail arrows.', 'slider_pro') .'<br/><b>'. 
																__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_arrows_hide_duration </i>', 
							
							'thumbnail_arrows_show_duration' => __('Indicates the duration for the fade in animation of the thumbnail arrows.', 'slider_pro') .'<br/><b>'. 
																__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_arrows_show_duration </i>', 
							
							'thumbnail_buttons' => __('Indicates whether the navigation thumbnails will have buttons (bullets) for navigating through thumbnail pages.', 'slider_pro') .'<br/><b>'. 
												   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_buttons </i>', 
							
							'fade_thumbnail_buttons' => __('Indicates whether the thumbnail buttons will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> fade_thumbnail_buttons </i>', 
							
							'thumbnail_buttons_hide_duration' => __('Indicates the duration for the fade out animation of the thumbnail buttons.', 'slider_pro') .'<br/><b>'. 
																 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_buttons_hide_duration </i>', 
							
							'thumbnail_buttons_show_duration' => __('Indicates the duration for the fade in animation of the thumbnail buttons.', 'slider_pro') .'<br/><b>'. 
																 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_buttons_show_duration </i>', 
							
							'thumbnail_scrollbar' => __('Indicates whether the navigation thumbnails will have a scrollbar.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scrollbar </i>', 
							
							'fade_thumbnail_scrollbar' => __('Indicates whether the thumbnail scrollbar will fade in/out on hover.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> fade_thumbnail_scrollbar </i>', 
							
							'thumbnail_scrollbar_hide_duration' => __('Indicates the duration for the fade out animation of the thumbnail scrollbar.', 'slider_pro') .'<br/><b>'. 
																   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scrollbar_hide_duration </i>', 
							
							'thumbnail_scrollbar_show_duration' => __('Indicates the duration for the fade in animation of the thumbnail scrollbar.', 'slider_pro') .'<br/><b>'. 
																   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scrollbar_show_duration </i>', 
							
							'thumbnail_scrollbar_ease' => __('Indicates the easing amount for the scrollbar scrolling.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_scrollbar_ease </i>', 
							
							'scrollbar_arrow_scroll_amount' => __('Sets the amount, in pixels, by which the thumbnails will be scrolled when one of the scrollbar\'s arrows is clicked.', 'slider_pro') .'<br/><b>'. 
															   __('Setting Name:', 'slider_pro') .'</b><i> scrollbar_arrow_scroll_amount </i>', 		
							
							'thumbnail_mouse_scroll' => __('Indicates whether the thumbnails can be scrolled by moving the mouse over them.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_scroll </i>', 
							
							'thumbnail_mouse_scroll_speed' => __('Sets the speed of the thumbnail mouse scrolling.', 'slider_pro') .'<br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_scroll_speed </i>', 
							
							
							'thumbnail_mouse_scroll_ease' => __('Sets the ease of the mouse scrolling when the mouse leaves the thumbnails area.', 'slider_pro') .'<br/><b>'. 
															 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_scroll_ease </i>', 
							
							'thumbnail_mouse_wheel' => __('Indicates whether the thumbnails can be scrolled using the mouse wheel.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_wheel </i>', 
							
							'thumbnail_mouse_wheel_speed' => __('Sets the speed of the thumbnail mouse wheel scrolling.', 'slider_pro') .'<br/><b>'. 
															 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_wheel_speed </i>', 
							
							'thumbnail_mouse_wheel_reverse' => __('Indicates whether the thumbnails will be scrolled in the opposite direction when mouse wheel scrolling is used.', 'slider_pro') .'<br/><b>'.
															   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_mouse_wheel_reverse </i>', 
							
							'thumbnail_caption_position' => __('Sets the position of the caption inside the thumbnail. Can be set to \'top\' or \'bottom\'.', 'slider_pro') .'<br/><b>'. 
															__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption_position </i>', 
							
							'hide_thumbnail_caption' => __('Indicates whether the thumbnail caption will be hidden/shown on hover.', 'slider_pro') .'<br/><b>'. 
														__('Setting Name:', 'slider_pro') .'</b><i> hide_thumbnail_caption </i>', 
							
							'thumbnail_caption_effect' => __('Sets the animation effect type for the captions.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption_effect </i>', 
							
							'thumbnail_caption_show_duration' => __('Sets the duration of the fade/slide in animation of the caption.', 'slider_pro') .'<br/><b>'. 
																 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption_show_duration </i>', 
							
							'thumbnail_caption_hide_duration' => __('Sets the duration of the fade/slide out animation of the caption.', 'slider_pro') .'<br/><b>'. 
																 __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption_hide_duration </i>', 
							
							'thumbnail_caption_easing' => __('Sets the easing of the caption\'s animation.', 'slider_pro') .' <br/><br/><b>'. 
														  __('Short names:', 'slider_pro') . '</b><br/>
															  I - in; O - out; IO - inOut <br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption_easing </i>', 
							
							'tooltip_show_duration' => __('Sets the duration of the tooltip\'s fade in animation.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> tooltip_show_duration </i>', 
							
							'tooltip_hide_duration' => __('Sets the duration of the tooltip\'s fade out animation.', 'slider_pro') .'<br/><b>'. 
													   __('Setting Name:', 'slider_pro') .'</b><i> tooltip_hide_duration </i>', 
							
							'hide_caption' => __('Indicates whether the slide caption will be hidden/shown on hover.', 'slider_pro') .'<br/><b>'. 
											  __('Setting Name:', 'slider_pro') .'</b><i> hide_caption </i>', 
							
							'caption_position' => __('Sets the position of the caption inside the slide. Can be set to \'top\', \'bottom\', \'left\', \'right\' or \'custom\'.', 'slider_pro') .'<br/><b>'. 
												  __('Setting Name:', 'slider_pro') .'</b><i> caption_position </i>', 
							
							'caption_background_opacity' => __('Sets the caption\'s background opacity.', 'slider_pro') .'<br/><b>'. 
															__('Setting Name:', 'slider_pro') .'</b><i> caption_background_opacity </i>', 
							
							'caption_background_color' => __('Sets the caption\'s background color.', 'slider_pro') .'<br/><b>'. 
														  __('Setting Name:', 'slider_pro') .'</b><i> caption_background_color </i>', 
							
							'caption_show_effect' => __('Sets the effect type for the caption\'s show animation.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> caption_show_effect </i>', 
							
							'caption_show_effect_duration' => __('Sets the duration for the caption\'s show animation.', 'slider_pro') .'<br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> caption_show_effect_duration </i>', 
							
							'caption_show_effect_easing' => __('Sets the easing type for the caption\'s show animation.', 'slider_pro') .' <br/><br/>' .
															__('Short names:', 'slider_pro') . '<br/>
															    I - in; O - out; IO - inOut <br/><b>'. 
															__('Setting Name:', 'slider_pro') .'</b><i> caption_show_effect_easing </i>', 
							
							'caption_show_slide_direction' => __('Sets the direction of the sliding for the caption\'s show animation, when the slide effect is used.', 'slider_pro') .'<br/><br/><b>'. 
															  __('Short names:', 'slider_pro') . '</b><br/>
															  	 T - top ; B - bottom ; L - left ; R - right <br/>
												   				 -> - to (shows the direction) <br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> caption_show_slide_direction </i>', 
							
							'caption_hide_effect' => __('Sets the effect type for the caption\'s hide animation.', 'slider_pro') .'<br/><b>'. 
													 __('Setting Name:', 'slider_pro') .'</b><i> caption_hide_effect </i>', 
							
							'caption_hide_effect_duration' => __('Sets the duration for the caption\'s hide animation.', 'slider_pro') .'<br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> caption_hide_effect_duration </i>', 
							
							'caption_hide_effect_easing' => __('Sets the easing type for the caption\'s hide animation.', 'slider_pro') .'<br/><br/><b>'. 
															__('Short names:', 'slider_pro') . '</b><br/>
															    I - in; O - out; IO - inOut <br/><b>'. 
															__('Setting Name:', 'slider_pro') .'</b><i> caption_hide_effect_easing </i>', 
							
							'caption_hide_slide_direction' => __('Sets the direction of the sliding for the caption\'s hide animation, when the slide effect is used.', 'slider_pro') .'<br/><br/><b>'. 
															  __('Short names:', 'slider_pro') . '</b><br/>
															  	 T - top ; B - bottom ; L - left ; R - right <br/>
												   				 -> - to (shows the direction) <br/><b>'. 
															  __('Setting Name:', 'slider_pro') .'</b><i> caption_hide_slide_direction </i>', 
							
							'caption_size' => __('Sets the width/height of the caption\'s background, unless the caption\'s position is \'custom\'', 'slider_pro') .'<br/><b>'. 
											  __('Setting Name:', 'slider_pro') .'</b><i> caption_size </i>', 
							
							'caption_left' => __('Sets the left position of the caption when caption\'s position is \'custom\'', 'slider_pro') .'<br/><b>'. 
											  __('Setting Name:', 'slider_pro') .'</b><i> caption_left </i>', 
							
							'caption_top' => __('Sets the left position of the caption when caption\'s position is \'custom\'', 'slider_pro') .'<br/><b>'. 
											 __('Setting Name:', 'slider_pro') .'</b><i> caption_top </i>', 
							
							'caption_width' => __('Sets the width of the caption when caption\'s position is \'custom\'', 'slider_pro') .'<br/><b>'. 
											   __('Setting Name:', 'slider_pro') .'</b><i> caption_width </i>', 
							
							'caption_height' => __('Sets the height of the caption when caption\'s position is \'custom\'', 'slider_pro') .'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> caption_height </i>', 
							
							'image_path' => __('The path to the slide\'s image.', 'slider_pro') .'<br/><b>'. 
											__('Setting Name:', 'slider_pro') .'</b><i> image </i>', 
							
							'image_alt' => __('The ALT text for the slide\'s image.', 'slider_pro') .'<br/><b>'. 
										   __('Setting Name:', 'slider_pro') .'</b><i> alt </i>', 
							
							'image_link' => __('The link for the current slide.', 'slider_pro') .'<br/><b>'. 
											__('Setting Name:', 'slider_pro') .'</b><i> link </i>', 
							
							'thumbnail_path' => __('Sets a custom thumbnail image for the current slide. If no path is specified, a thumbnail will be automatically generated from the slide\'s main image.', 'slider_pro')
												.'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> thumbnail_image </i>', 
							
							'thumbnail_alt' => __('The ALT text for the thumbnail image.', 'slider_pro') .'<br/><b>'. 
											   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_alt </i>', 
							
							'thumbnail_caption_content' => __('Sets a caption for the thumbnail image. The caption will be displayed only if the Thumbnails Type is set to \'navigation\'.', 'slider_pro') .'<br/><b>'. 
														   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_caption </i>', 
							
							'thumbnail_tooltip_content' => __('Sets a tooltip for the thumbnail image. The tooltip will be displayed only if the Thumbnails Type is set to \'navigation\'.', 'slider_pro') .'<br/><b>'. 
														   __('Setting Name:', 'slider_pro') .'</b><i> thumbnail_tooltip </i>',
															
							'lightbox_content' => __('The path to the lightbox content. Can be a path to an image a YouTube/Vimeo video or other flash content.', 'slider_pro') .'<br/><b>'. 
												  __('Setting Name:', 'slider_pro') .'</b><i> lightbox_content </i>', 
													 
							'lightbox_title' => __('The title of the lightbox.', 'slider_pro') .'<br/><b>'. 
												__('Setting Name:', 'slider_pro') .'</b><i> lightbox_title </i>', 
													 
							'lightbox_description' => __('The description of the lightbox.', 'slider_pro') .'<br/><b>'. 
													  __('Setting Name:', 'slider_pro') .'</b><i> lightbox_description </i>', 
							
							);


$sp_timthumb_align = array('leftTop' => 'tl', 'centerTop' => 't', 'rightTop' => 'tr', 'leftCenter' => 'l', 'centerCenter' => 'c', 
					       'rightCenter' => 'r', 'leftBottom' => 'bl', 'centerBottom' => 'b', 'rightBottom' => 'br');


// sidebar panels
$sp_slider_settings_panels = array('publish' => 'panel-publish.php',
									'general' => 'panel-general.php',
									'slideshow' => 'panel-slideshow.php',
									'lightbox' => 'panel-lightbox.php',
									'timer_animation' => 'panel-timer-animation.php',
									'slide_navigation_controls' => 'panel-slide-navigation-controls.php',
									'transition_effects' => 'panel-transition-effects.php',
									'thumbnails' => 'panel-thumbnails.php',
									'captions' => 'panel-captions.php',
									'slides_order' => 'panel-slides-order.php');
								

$sp_months = array('01' => 'January', '02' => 'February', '03' => 'March', '04' => 'April', '05' => 'May', '06' => 'June', 
				   '07' => 'July', '08' => 'August', '09' => 'September', '10' => 'October', '11' => 'November', '12' => 'December',);
?>